#include <GUIConstantsEx.au3>
#include 'GroupCheckBox.au3'

Global $aCB_Data[][2] = _
	[ _
		['Folder C:\1', 'C:\1'], _
		['Folder C:\2', 'C:\2'], _
		['Folder %temp%', @TempDir], _
		['Folder %windir%\temp', @WindowsDir & '\temp'] _
	]

Opt('GUIOnEventMode', 1)

$hGUI = GUICreate('GroupCheckBox Example 2', 500, 250)

$hGroupCheckBox = _GroupCheckBox_Create($aCB_Data, 20, 20, 130, 17, 2, 30, 10)

For $i = 1 To _GroupCheckBox_GetInfo($hGroupCheckBox)
	GUICtrlSetOnEvent(_GroupCheckBox_GetInfo($hGroupCheckBox, $i, $GCB_INDEX_CTRLID), '_Events')
Next

GUICtrlCreateLabel('Current checked size:', 20, 110, 170, 12)
$iCurSize_Lbl = GUICtrlCreateLabel('', 135, 111, 70, 12)
GUICtrlCreateLabel('Total checked size:', 20, 130, 170, 12)
$iSelSize_Lbl = GUICtrlCreateLabel('0 MB', 135, 131, 70, 12)
GUICtrlCreateLabel('Deleted size:', 20, 150, 170, 12)
$iDelSize_Lbl = GUICtrlCreateLabel('', 105, 151, 70, 12)
GUICtrlCreateLabel('Files:', 50, 170, 170, 12)
$iDelFiles_Lbl = GUICtrlCreateLabel('', 135, 171, 70, 12)
GUICtrlCreateLabel('Folders:', 50, 190, 170, 12)
$iDelDirs_Lbl = GUICtrlCreateLabel('', 135, 191, 70, 12)

$iDel_Bttn = GUICtrlCreateButton('Empty content...', 300, 100, 140)
GUICtrlSetOnEvent(-1, '_Events')

GUISetOnEvent($GUI_EVENT_CLOSE, '_Events')
GUISetState(@SW_SHOW)

While 1
	Sleep(10)
WEnd

Func _Events()
	Switch @GUI_CtrlId
		Case $GUI_EVENT_CLOSE
			Exit
		Case _GroupCheckBox_GetEvent($hGroupCheckBox, @GUI_CtrlId)
			_Sel_Calc(@GUI_CtrlId)
		Case $iDel_Bttn
			If _GroupCheckBox_GetState($hGroupCheckBox) = $GCB_CHECK_STATE_NONE Then
				MsgBox(48, 'Error', 'Please check folder.', 0, $hGUI)
				Return
			EndIf
			
			If MsgBox(256 + 52, 'Attention!', 'Are you sure, empty content of checked folders?', 0, $hGUI) = 6 Then
				_Sel_Del()
			EndIf
	EndSwitch
EndFunc

Func _Sel_Calc($iCtrlID)
	Local $aInfo, $iDirSize = 0, $iSize = 0
	
	GUICtrlSetData($iCurSize_Lbl, '')
	
	For $i = 1 To _GroupCheckBox_GetInfo($hGroupCheckBox)
		$aInfo = _GroupCheckBox_GetInfo($hGroupCheckBox, $i, $GCB_INDEX_ALL)
		
		$iDirSize = DirGetSize($aInfo[$GCB_INDEX_PARAM])
		
		If $iDirSize < 0 Then
			$iDirSize = 0
		EndIf
		
		$iDirSize = Round($iDirSize / 1048576, 2)
		
		If GUICtrlRead($aInfo[$GCB_INDEX_CTRLID]) = $GUI_CHECKED Then
			$iSize += $iDirSize
			
			If $aInfo[$GCB_INDEX_CTRLID] = $iCtrlID Then
				GUICtrlSetData($iCurSize_Lbl, $iDirSize & ' MB')
			EndIf
		EndIf
	Next
	
	GUICtrlSetData($iSelSize_Lbl, $iSize & ' MB')
EndFunc

Func _Sel_Del()
	Local $aInfo, $aSize, $iDelSize = 0, $iFiles = 0, $iDirs = 0
	Local $hSearch, $sFile
	
	For $i = 1 To _GroupCheckBox_GetInfo($hGroupCheckBox)
		$aInfo = _GroupCheckBox_GetInfo($hGroupCheckBox, $i, $GCB_INDEX_ALL)
		
		If GUICtrlRead($aInfo[$GCB_INDEX_CTRLID]) = $GUI_CHECKED Then
			$aSize = DirGetSize($aInfo[$GCB_INDEX_PARAM], 1)
			
			If Not IsArray($aSize) Then
				ContinueLoop
			EndIf
			
			$iDelSize += $aSize[0]
			$iFiles += $aSize[1]
			$iDirs += $aSize[2]
			
			$hSearch = FileFindFirstFile($aInfo[$GCB_INDEX_PARAM] & '\*')
			
			While 1
				$sFile = FileFindNextFile($hSearch)
				If @error Then ExitLoop
				
				If @extended Then
					DirRemove($aInfo[$GCB_INDEX_PARAM] & '\' & $sFile, 1)
				EndIf
			WEnd
			
			FileClose($hSearch)
			FileDelete($aInfo[$GCB_INDEX_PARAM] & '\*')
		EndIf
	Next
	
	GUICtrlSetData($iDelSize_Lbl, Round($iDelSize / 1048576, 2) & ' MB')
	GUICtrlSetData($iDelFiles_Lbl, $iFiles)
	GUICtrlSetData($iDelDirs_Lbl, $iDirs)
	
	_Sel_Calc(0)
EndFunc